// $Id: CFPUInformation.cpp,v 1.2 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CFPUInformation.hpp"
using Exponent::Host::CFPUInformation;

/**
 * @def HAS_MMX
 * edx Output flag
 */
#define HAS_MMX  0x00800000

/**
 * @def HAS_SSE
 * edx Output flag
 */
#define HAS_SSE  0x02000000

/**
 * @def HAS_SSE2
 * edx Output flag
 */
#define HAS_SSE2 0x04000000

/**
 * @def HAS_SSE3
 * ecx Output flag
 */
#define HAS_SSE3 0x10000001

/**
 * @def HAS_HT
 * edx Output flag
 */
#define HAS_HT   0x10000000

//	===========================================================================
bool CFPUInformation::CFPU_INFORMATION_HAS_MMX = false;

//	===========================================================================
bool CFPUInformation::CFPU_INFORMATION_HAS_SSE = false;

//	===========================================================================
bool CFPUInformation::CFPU_INFORMATION_HAS_SSE2 = false;

//	===========================================================================
bool CFPUInformation::CFPU_INFORMATION_HAS_SSE3 = false;

//	===========================================================================
bool CFPUInformation::CFPU_INFORMATION_HAS_HT = false;

//	===========================================================================
void CFPUInformation::initialiseCPUInformation()
{
#ifdef WIN32

	// Get the cpu information
	unsigned long edxFlag = 0;
    unsigned long ecxFlag = 0;
    _asm 
    {
        mov eax, 0x00000001  	
        CPUID
        mov ecxFlag, ecx	
        mov edxFlag, edx	
    }

	// Store the values
    CFPU_INFORMATION_HAS_MMX  = (edxFlag & HAS_MMX)  > 0;
    CFPU_INFORMATION_HAS_SSE  = (edxFlag & HAS_SSE)  > 0;
    CFPU_INFORMATION_HAS_SSE2 = (edxFlag & HAS_SSE2) > 0;
    CFPU_INFORMATION_HAS_SSE3 = (ecxFlag & HAS_SSE3) > 0;
    CFPU_INFORMATION_HAS_HT   = (edxFlag & HAS_HT)   > 0;
#else

#endif
}

//	===========================================================================
void CFPUInformation::dumpFPUInfoToFile(CSystemString &path)
{
	// Check that the path is correct..
	if (!path.hasExtension())
	{
		path.appendString("FPUStats.txt");
	}

	// Create the stream
	CTextStream stream(path, CTextStream::e_output);

	// Output
	dumpFPUInfoToFile(stream);

	// Close the file
	stream.closeStream();
}

//	===========================================================================
void CFPUInformation::dumpFPUInfoToFile(CTextStream &stream)
{
	if (stream.isStreamOpen())
	{
		stream << "Exponent FPU info extraction tool \n";
		stream << "----------------------------------\n";
		stream << "Has MMX : " << CFPU_INFORMATION_HAS_MMX  << "\n";
		stream << "Has SSE : " << CFPU_INFORMATION_HAS_SSE  << "\n";
		stream << "Has SSE2: " << CFPU_INFORMATION_HAS_SSE2 << "\n";
		stream << "Has SSE3: " << CFPU_INFORMATION_HAS_SSE3 << "\n";
		stream << "Has HT  : " << CFPU_INFORMATION_HAS_HT   << "\n";
		stream << "----------------------------------\n";
	}
}